﻿<?LassoScript
/*
This demo uses font variables for text objects.

Author: Jolle Carlestam
Prepared for the Lasso Developer Conference in Chicago 2008
Use and alter freely but please keep a reference to where you found it
*/

//First set some vars holding basic data.
var('pagetype' = 'A4',
	'pageheight' = 842, // points
	'pagewidth' = 595);

// If you prefer US-Letter sized paper uncomment this section
/*
var('pagetype' = 'LETTER',
	'pageheight' = 792, // points
	'pagewidth' = 612);

*/

// Create the pdf_doc object
var( 'pdf' = pdf_doc( -size = $pagetype,
	-margins = array( 25.0, 25.0, 25.0, 25.0), -nocompress));

// Setting font variables with some of the standard fonts available
var('HelvBold14Black' = (pdf_font:
	-face = 'Helvetica-Bold',
	-size = 14,
	-color = '#000000'));

var('TimesPlain10' = (pdf_font:
	-face = 'Times-Roman',
	-size = 10)); // without a color param Lasso uses default black color

var('ZapfDingbats10' = (pdf_font:
	-face = 'ZapfDingbats',
	-size = 10));

// Setting font variables pointing to font files on the server
// If you use a nonstandard font set the -embed param to include the font information
// into the pdf file. That way you wont have to rely on the font being installed on
// any client system
var('WarnockPro' = (pdf_font:
	-file = 'fonts/WarnockPro-Regular.otf',
	-embed)); // Without a size param Lasso uses default 12 points

var('Garamond' = (pdf_font:
	-file = 'fonts/AdobeGaramond-Regular.ttf', // Converted using Transtype
	-embed));

var('Papyrus' = (pdf_font:
	-file = 'fonts/Papyrus.ttf', // Converted using Transtype
	-embed));



// Adding text to the flow of the page using the font vars
$pdf -> add(pdf_text( 'Helvetica-Bold 14 points.\rLorem ipsum dolor sit amet, consectetuer adipiscing elit. Pellentesque fringilla ipsum non felis.',
		-font = $HelvBold14Black,
	-leading = 18));

// Adding a divider using a symbol font
$pdf -> add(pdf_text( 'ghj jhg',
		-font = $ZapfDingbats10,
		-leading = 14,
		-align = 'center'));

$pdf -> add(pdf_text( 'Times 10 points.\rLorem ipsum dolor sit amet, consectetuer adipiscing elit. Pellentesque fringilla ipsum non felis.',
		-font = $TimesPlain10,
		-leading = 14));

$pdf -> add(pdf_text( 'ghj jhg', // The divider again
		-font = $ZapfDingbats10,
		-leading = 14,
		-align = 'center'));

$pdf -> add(pdf_text( 'WarnockPro-Regular 12 points.\rLorem ipsum dolor sit amet, consectetuer adipiscing elit. Pellentesque fringilla ipsum non felis.',
		-font = $WarnockPro,
		-leading = 16));

$pdf -> add(pdf_text( 'ghj jhg', // The divider again
		-font = $ZapfDingbats10,
		-leading = 14,
		-align = 'center'));

$pdf -> add(pdf_text( 'Adobe Garamond Regular 12 points.\rLorem ipsum dolor sit amet, consectetuer adipiscing elit. Pellentesque fringilla ipsum non felis.',
		-font = $Garamond,
		-leading = 16));

$pdf -> add(pdf_text( 'ghj jhg', // The divider again
		-font = $ZapfDingbats10,
		-leading = 14,
		-align = 'center'));

$pdf -> add(pdf_text( 'Papyrus 12 points.\rLorem ipsum dolor sit amet, consectetuer adipiscing elit. Pellentesque fringilla ipsum non felis.',
		-font = $Papyrus,
		-leading = 16));

$pdf -> add(pdf_text( 'ghj jhg', // The divider again
		-font = $ZapfDingbats10,
		-leading = 14,
		-align = 'center'));

// Using no font variable defaults to Helvetica 12 points
$pdf -> add(pdf_text( 'Helvetica 12 points.\rLorem ipsum dolor sit amet, consectetuer adipiscing elit. Pellentesque fringilla ipsum non felis.',
		-leading = 16));

$pdf -> add(pdf_text( 'ghj jhg', // The divider again
		-font = $ZapfDingbats10,
		-leading = 14,
		-align = 'center'));

// Adding color to text.

// First create some color vars
var('gray03' = pdf_color('gray', 0.3));
var('greenRGB' = pdf_color('rgb', 0, 0.9, 0.1));
var('E64_1CMYK' = pdf_color('cmyk', 0.3, 0.9, 1, 0));
var('E64_1Spot_10CMYK' = pdf_color('spot', 'PANTONE E 64-1', 1, $E64_1CMYK));

// Adding text using a color var
$pdf -> add(pdf_text( 'Gray color 30%.\rLorem ipsum dolor sit amet, consectetuer adipiscing elit. Pellentesque fringilla ipsum non felis.',
		-leading = 16, -color = $gray03));

$pdf -> add(pdf_text( 'ghj jhg', // The divider again
		-font = $ZapfDingbats10,
		-leading = 14,
		-align = 'center'));

$pdf -> add(pdf_text( 'RGB color in some kind of Green.\rLorem ipsum dolor sit amet, consectetuer adipiscing elit. Pellentesque fringilla ipsum non felis.',
		-leading = 16, -color = $greenRGB));

$pdf -> add(pdf_text( 'ghj jhg', // The divider again
		-font = $ZapfDingbats10,
		-leading = 14,
		-align = 'center'));

$pdf -> add(pdf_text( 'CMYK color emulating PANTONE E64-1.\rLorem ipsum dolor sit amet, consectetuer adipiscing elit. Pellentesque fringilla ipsum non felis.',
		-leading = 16, -color = $E64_1CMYK));

$pdf -> add(pdf_text( 'ghj jhg', // The divider again
		-font = $ZapfDingbats10,
		-leading = 14,
		-align = 'center'));

$pdf -> add(pdf_text( 'Spot color called PANTONE E64-1.\rLorem ipsum dolor sit amet, consectetuer adipiscing elit. Pellentesque fringilla ipsum non felis.',
		-leading = 16, -color = $E64_1Spot_10CMYK));

$pdf -> add(pdf_text( 'ghj jhg', // The divider again
		-font = $ZapfDingbats10,
		-leading = 14,
		-align = 'center'));

// Creating a font var, this time with a color object
var('ChalkboardBold' = (pdf_font:
	-file = 'fonts/ChalkboardBold.ttf',
	-color = $greenRGB, // Adding a color param to the font object
	-embed));

$pdf -> add(pdf_text( 'Using the font objects color value.\rChalkboard Bold 12 points\rLorem ipsum dolor sit amet, consectetuer adipiscing elit. Pellentesque fringilla ipsum non felis.',
		-font = $ChalkboardBold,
		-leading = 16));

$pdf -> add(pdf_text( 'ghj jhg', // The divider again
		-font = $ZapfDingbats10,
		-leading = 14,
		-align = 'center'));

$pdf -> add(pdf_text( 'Overriding the color with a setting in the PDF_Text object.\rChalkboard Bold 12 points\rLorem ipsum dolor sit amet, consectetuer adipiscing elit. Pellentesque fringilla ipsum non felis.',
		-font = $ChalkboardBold,
		-leading = 16,
		-color = $E64_1Spot_10CMYK));

$pdf -> add(pdf_text( 'ghj jhg', // The divider again
		-font = $ZapfDingbats10,
		-leading = 14,
		-align = 'center'));


// Finally close the pdf_doc and serve it
$pdf -> close;
pdf_serve( -content = $pdf, -file = 'demo7.pdf');

?>